#ifndef __DM_USBHID_H__
#define __DM_USBHID_H__

///////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

///////////////////////////////////////////////////////////////////////////////

#define HID_NOT_ACTIVE  0
#define HID_ACTIVE      1

#define USB_HID_PORT              42872

///////////////////////////////////////////////////////////////////////////////
// Serial join configuration packet for DM HID Sink

#define USB_HID_DATA_MOUSE        0x01
#define USB_HID_DATA_KEYBOARD     0x02
#define USB_HID_DATA_TOUCHSCREEN  0x04

#define USB_HID_CONNECTION_TCP    0x01
#define USB_HID_CONNECTION_UDP    0x02

typedef struct
{
  unsigned long 	destIPAddress;      // IP address to connect/send data to
	unsigned short  destPort; 	        // port number to connect/send data to
	unsigned char 	connectionType; 	  // bit 0 = TCP, bit 1 = UDP
	unsigned char 	dataTypesDesired; 	// Bit mask: Bit 0 = Mouse, Bit 1 =
                                      // Keyboard, Bit 2 = Touch Screen
} HID_SWITCH_COMMAND, *pHID_SWITCH_COMMAND;

///////////////////////////////////////////////////////////////////////////////
// HID Data Packet Formats
// The HID data packets follow the standard CIP packet format.

#define HID_UDPP_MSG		0x50  //Used for sending Keyboard and mouse data
#define HID_DIRECT_TOUCH_MSG	0x51  //Used for sending Touch data

#pragma pack(1)

typedef struct		//CIP Header Format
{
  unsigned char PacketType; 	//0x50 or 0x51
  unsigned char TransNumber;	//Not used (0)
  unsigned short Flags;		//Not used (0)
  unsigned short DataLength;	//Bytes to follow (5)
} HID_HEADER_INFO, *pHID_HEADER_INFO;

typedef struct		//5 bytes of data follow the header in the packet
{
  HID_HEADER_INFO Header;
  unsigned char   Data[8];
} *pHID_PACKET, HID_PACKET;

#pragma pack()

///////////////////////////////////////////////////////////////////////////////

//USB Tx/Rx function error codes
#define USB_ERROR_PACKET_TO_BIG   -1
#define USB_ERROR_SEND_TIMEOUT    -2
#define USB_ERROR_NOT_CONFIGURED  -3

//USB Tx/Rx packet sizes. counts must not exceed these values.
#define USB_MOUSE_PACKET_SIZE     8
#define USB_RELATIVE_MOUSE_REPORT_SIZE   5
#define USB_CONSUMER_CONTROL_REPORT_SIZE   3
#define USB_ABSOLUTE_MOUSE_REPORT_SIZE   6
//#define USB_SYSTEM_CONTROL_REPORT_SIZE   3 // not yet implemented
#define USB_KEYBOARD_PACKET_SIZE  8
#define USB_VENDOR_PACKET_SIZE    8
#define USB_MULTI_TOUCH_PACKET_SIZE    7

#define USB_RELATIVE_MOUSE_REPORT_ID    0x01
#define USB_CONSUMER_CONTROL_REPORT_ID  0x02
#define USB_ABSOLUTE_MOUSE_REPORT_ID    0x03
#define USB_SYSTEM_CONTROL_REPORT_ID    0x04
#define USB_MULTI_TOUCH_REPORT_ID       0x05

#define USB_CONSOLE_PACKET_SIZE  32


#define UDPP_PACKET_ID_MASK           0x03
#define UDPP_RELATIVE_MOUSE_ID        0x01
#define UDPP_STANDARD_KEYBOARD_ID     0x03
#define UDPP_EXTENDED_ID              0x02
#define UDPP_PACKET_EID_MASK          (~UDPP_PACKET_ID_MASK)
#define UDPP_CONSUMER_CONTROL_EID     (0x02<<2)
#define UDPP_ABSOLUTE_MOUSE_EID       (0x03<<2)
#define UDPP_SYSTEM_CONTROL_EID       (0x04<<2)
#define UDPP_LED_STATUS_EID           (0x05<<2)
#define UDPP_MULTI_TOUCH_EID          (0x06<<2)

//The standard button byte. one bit is awlays set
#define HID_BUTTON_BYTE   0x08

#define HID_LEFT_BUTTON   0x01
#define HID_RIGHT_BUTTON  0x02
#define HID_MIDDLE_BUTTON 0x04
#define HID_SIGN_X        0x10
#define HID_SIGN_Y        0x20

#define UDPP_LEFT_BUTTON   0x40
#define UDPP_RIGHT_BUTTON  0x20
#define UDPP_MIDDLE_BUTTON 0x10
#define UDPP_SIGN_X        0x04
#define UDPP_SIGN_Y        0x08

#define HID_UDPP_MSG		0x50
#define HID_DIRECT_TOUCH_MSG	0x51



#define HID_1            89
#define HID_2            90
#define HID_3            91
#define HID_4            92
#define HID_5            93
#define HID_6            94
#define HID_7            95
#define HID_8            96
#define HID_9            97
#define HID_0            98
#define HID_ENTER        88
#define HID_BACKSPACE    42
#define HID_LEFT         80
#define HID_RIGHT        79
#define HID_DIVIDE       84
#define HID_MULTIPLY     85
#define HID_MINUS        86
#define HID_PLUS         87

#define HID_A            4
#define HID_B            5
#define HID_C            6
#define HID_D            7
#define HID_E            8
#define HID_F            9
#define HID_G            10
#define HID_H            11
#define HID_I            12
#define HID_J            13
#define HID_K            14
#define HID_L            15
#define HID_M            16
#define HID_N            17
#define HID_O            18
#define HID_P            19
#define HID_Q            20
#define HID_R            21
#define HID_S            22
#define HID_T            23
#define HID_U            24
#define HID_V            25
#define HID_W            26
#define HID_X            27
#define HID_Y            28
#define HID_Z            29

#define HID_SPACEBAR     44

#define HID_UNDERSCORE   45
#define HID_SLASH        56
#define HID_BACKSLASH    49
#define HID_DOT          55
#define HID_AT           85
#define HID_SB           HID_SPACEBAR
#define HID_MN           HID_MINUS
#define HID_SL           HID_SLASH
#define HID_BS           HID_BACKSLASH


// HID MODIFIERS KEYS
#define HID_MODIFIER_NONE               0x00
#define HID_MODIFIER_LEFT_CTRL          0x01
#define HID_MODIFIER_LEFT_SHIFT         0x02
#define HID_MODIFIER_LEFT_ALT           0x04
#define HID_MODIFIER_LEFT_GUI           0x08
#define HID_MODIFIER_RIGHT_CTRL         0x10
#define HID_MODIFIER_RIGHT_SHIFT        0x20
#define HID_MODIFIER_RIGHT_ALT          0x40
#define HID_MODIFIER_RIGHT_GUI          0x80



// When key is pressed (first polling), transmit new data in report (key, and
// key modifier if used).
// If key continue to be pressed (next pollings), don't transmit any report,
// and so Windows will repeat the key automatically.
// When key is released, transmit a NULL report (full of "0")
//      0           1           2         3         4         5         6         7
//  HID_MODIFIER    0        HID_KEY      0         0         0         0         0



///////////////////////////////////////////////////////////////////////////////

extern unsigned char Host_Enumerated_Flag;
extern unsigned char SOF_Flag;

///////////////////////////////////////////////////////////////////////////////

extern void USB_Init(UINT32 mode);

extern void USB_ConnetToHost(void);
extern void USB_DisconnetFromHost(void);

extern void USB_WaitForInitialHostConnection(void);
extern void USBGeneric_WaitForInitialHostConnection(void);
extern INT32 USB_GenericWrite(BYTE EpNum,UINT8* pData, UINT32 count);

extern void USB_InitSemaphores(void);
extern INT32 USB_IsReady(void);

extern INT32 USB_SendMousePacket(UINT8* pData, UINT32 count);
extern INT32 USB_SendKeyboardPacket(UINT8* pData, UINT32 count);
extern INT32 USB_SendVendorPacket(UINT8* pData, UINT32 count);
extern INT32 USB_GetVendorPacket(UINT8* pData, UINT32 bufferSize);

extern INT32 USB_GetConsolePacket(UINT8* pData, UINT32 bufferSize);
extern INT32 USB_SendConsolePacket(UINT8* pData, UINT32 count);
extern INT32 USB_GenericRead(BYTE EpNum, UINT8 *pBuffer);
extern INT32 USB_GenericRead_DBLBUF(BYTE EpNum, UINT8 *pBuffer);




#ifdef __cplusplus
}
#endif

#endif  //__DM_USBHID_H__
